qui {

noi {
	/*************************************************/
	/************* Step 3.3. Multivariate analysis *****/
	/*************************************************/
}
		
	* Multivariate results
	
		* Load data
		cd ..
		cd "./4. Master data"
		use master_data_secondstep, clear
		cd ..

		* Keep relevant year
		keep if independence_years >= 0
		
		* Tempfile to collect estimation results
		preserve
		clear all
		set obs 38
		gen n = _n
		tempfile er
		save `er', emptyok
		restore
		
		* Feasible Generalized Leasdt Squares (baseline)
		noi di "FGLS approach:"
		noi di ""
		local count = 0
		foreach specification of numlist  1/4 {
			
			* Keep track of progress 
			local count = `count'+1
			noi di "Specification `specification'"

			preserve
			* Keep relevant variables
			keep cntrycode PTDIDD PTDIDD_se transition crisis open market_potential dem popshare initial_gdpcap referendum_dummy landlocked violent_secession bdeaths doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy year independence_years regioncode
	
			* Standardize continuous variables
			ds cntrycode year independence_years regioncode transition landlocked violent_secession referendum_dummy doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy PTDIDD_se, not
			foreach covariate in `r(varlist)' {
				egen `covariate'_std = std(`covariate')
				replace `covariate' = `covariate'_std
				drop `covariate'_std
				}
			
			if `specification' == 1 {				
				reg PTDIDD open market_potential dem popshare landlocked violent_secession bdeaths crisis transition doil i.year i.independence_years i.regioncode
				}
			if `specification' == 2 {				
				reg PTDIDD open market_potential dem popshare initial_gdpcap landlocked violent_secession bdeaths crisis transition doil i.year i.independence_years i.regioncode
				}
			if `specification' == 3 {	
				reg PTDIDD open market_potential dem popshare initial_gdpcap referendum_dummy landlocked violent_secession bdeaths crisis transition doil i.year i.independence_years i.regioncode
				}
			if `specification' == 4 {						
				reg PTDIDD open market_potential dem popshare initial_gdpcap referendum_dummy landlocked violent_secession bdeaths crisis transition doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy i.year i.independence_years i.regioncode
				}
			restore

			* Generate fixed effects
			levelsof independence_years, local(independence_years)
			foreach i in `independence_years' {
				if _se[`i'.independence_years] != 0 {
					gen i_`i' = 0
					replace i_`i' = 1 if independence_years == `i'
					}
				}
			levelsof year, local(year)
			foreach y in `year' {
				if _se[`y'.year] != 0 {
					gen y_`y' = 0
					replace y_`y' = 1 if year == `y'
					}
				}
			levelsof regioncode, local(regions)
			foreach c in `regions' {
				if _se[`c'.regioncode] != 0 {
					gen c_`c' = 0
					replace c_`c' = 1 if regioncode == `c'
					}
				}
			* Identify fixed effects
			preserve
			keep c_* y_* i_* 
			ds 
			local fixedeffects = r(varlist)
			restore

			* Define regression equation
			if `specification' == 1 {				
				global reg_eq open market_potential dem popshare landlocked violent_secession transition crisis bdeaths doil `fixedeffects'
				}
			if `specification' == 2 {				
				global reg_eq open market_potential dem popshare initial_gdpcap landlocked violent_secession transition crisis bdeaths doil `fixedeffects'
				}
			if `specification' == 3 {	
				global reg_eq open market_potential dem popshare initial_gdpcap referendum_dummy landlocked violent_secession bdeaths transition crisis doil `fixedeffects'
				}
			if `specification' == 4 {						
				global reg_eq open market_potential dem popshare initial_gdpcap referendum_dummy landlocked violent_secession bdeaths transition crisis doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy `fixedeffects'
				}

			* Drop missings
			preserve
			keep c_* y_* i_* cntrycode PTDIDD PTDIDD_se transition crisis open market_potential dem popshare initial_gdpcap referendum_dummy landlocked violent_secession bdeaths  doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy year independence_years regioncode

			* Standardize continuous variables
			ds c_* y_* i_* cntrycode year independence_years regioncode crisis transition landlocked violent_secession doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy year independence_years regioncode PTDIDD_se, not
			foreach covariate in `r(varlist)' {
				egen `covariate'_std = std(`covariate')
				replace `covariate' = `covariate'_std
				drop `covariate'_std
				}
			
			* Estimate model of interest
			reg PTDIDD $reg_eq 
			keep if e(sample)
			
			* Generate second-stage residuals
			reg PTDIDD $reg_eq
			predict resid, residuals
			gen residsq = resid^2
			sum residsq
			local sumresidsq = r(sum)

			* Get omega
			gen omegasq = PTDIDD_se^2
			mkmat omegasq, mat(omegasq)
			mat G = diag(omegasq)
			sum omegasq
			local sumomegasq = r(sum)

			* Generate necessary matrices
			gen ones = 1
			mkmat $reg_eq, mat(X)
			local N = rowsof(X)
			local k = colsof(X)
			mat S = inv(X'*X)*X'*G*X
			
			* Compute sigma & weights
			local tr_S = trace(S)
			local sigmahatsq = (`sumresidsq' - `sumomegasq' + `tr_S')/(`N' - `k')

			gen weight = 1/(sqrt(omegasq + `sigmahatsq'))
			
			*	Final second-step regression
			reg PTDIDD $reg_eq 
			reg PTDIDD $reg_eq [pweight = weight]
			local obs = `e(N)'
			local rsq = `e(r2_a)'
			tab cntrycode if e(sample)
			local countries = `r(r)'
			restore
	
			* Compute point estimates & SE's of parameters of interest
			preserve

			* Generate order
			gen n = _n
			gen str Channel = ""
			gen str varname = ""
			gen str estimate`count' = ""
				
			replace varname = "fgls`specification'_popshare" if n == 1
			replace varname = "fgls`specification'_popshare2" if n == 2
			replace varname = "fgls`specification'_open" if n == 3
			replace varname = "fgls`specification'_open2" if n == 4
			replace varname = "fgls`specification'_market_potential" if n == 5 
			replace varname = "fgls`specification'_market_potential2" if n == 6
			replace varname = "fgls`specification'_landlocked" if n == 7
			replace varname = "fgls`specification'_landlocked2" if n == 8
			replace varname = "fgls`specification'_dem" if n == 9
			replace varname = "fgls`specification'_dem2" if n == 10
			replace varname = "fgls`specification'_violent_secession" if n == 11
			replace varname = "fgls`specification'_violent_secession2" if n == 12
			replace varname = "fgls`specification'_bdeaths" if n == 13
			replace varname = "fgls`specification'_bdeaths2" if n == 14
			replace varname = "fgls`specification'_crisis" if n == 15
			replace varname = "fgls`specification'_crisis2" if n == 16
			replace varname = "fgls`specification'_transition" if n == 17
			replace varname = "fgls`specification'_transition2" if n == 18
			replace varname = "fgls`specification'_doil" if n == 19
			replace varname = "fgls`specification'_doil2" if n == 20
			replace varname = "fgls`specification'_initial_gdpcap" if n == 21
			replace varname = "fgls`specification'_initial_gdpcap2" if n == 22
			replace varname = "fgls`specification'_referendum_dummy" if n == 23
			replace varname = "fgls`specification'_referendum_dummy2" if n == 24
			replace varname = "fgls`specification'_EU_dummy" if n == 25
			replace varname = "fgls`specification'_EU_dummy2" if n == 26
			replace varname = "fgls`specification'_NATO_dummy" if n == 27
			replace varname = "fgls`specification'_NATO_dummy2" if n == 28
			replace varname = "fgls`specification'_AU_dummy" if n == 29
			replace varname = "fgls`specification'_AU_dummy2" if n == 30
			replace varname = "fgls`specification'_ASEAN_dummy" if n == 31
			replace varname = "fgls`specification'_ASEAN_dummy2" if n == 32
				
			replace Channel = "Population share" if n == 1
			replace Channel = "Trade openness" if n == 3
			replace Channel = "Market potential" if n == 5 
			replace Channel = "Landlocked" if n == 7
			replace Channel = "Democracy" if n == 9
			replace Channel = "Violent secession" if n == 11
			replace Channel = "Battle-related deaths" if n == 13
			replace Channel = "Financial crises" if n == 15
			replace Channel = "Transition country" if n == 17
			replace Channel = "Oil producing country" if n == 19
			replace Channel = "Initial per capita GDP" if n == 21
			replace Channel = "Independence-by-referendum" if n == 23
			replace Channel = "EU membership" if n == 25
			replace Channel = "NATO membership" if n == 27
			replace Channel = "African Union membership" if n == 29
			replace Channel = "ASEAN membership" if n == 31
			replace Channel = "\# Observations [\# countries]" if n == 33
			replace Channel = "Adjusted R$ ^{2}$" if n == 34
			replace Channel = "Region dummies" if n == 35
			replace Channel = "Year dummies" if n == 36
			replace Channel = "Years-of-independence dummies" if n == 37
			
			ds n y_* i_* c_*, not
			foreach variable in `r(varlist)' {
				cap local pvalue = 2*ttail(`e(N)',abs(_b[`variable']/_se[`variable']))
				if _rc == 0 {
					replace estimate`count' = string(round(_b[`variable'],.001),"%3.2f") if varname == "fgls`specification'_`variable'" & `pvalue' > .1
					replace estimate`count' = string(round(_b[`variable'],.001),"%3.2f")+"$^{*}$" if varname == "fgls`specification'_`variable'" & `pvalue' > .05 & `pvalue' <= .1
					replace estimate`count' = string(round(_b[`variable'],.001),"%3.2f")+"$^{**}$" if varname == "fgls`specification'_`variable'" & `pvalue' > .01 & `pvalue' <= .05
					replace estimate`count' = string(round(_b[`variable'],.001),"%3.2f")+"$^{***}$" if varname == "fgls`specification'_`variable'" & `pvalue' <= .01
					replace estimate`count' = "("+string(round(_se[`variable'],.001),"%3.2f")+")" if varname == "fgls`specification'_`variable'2"
					}
				cap local pvalue = 2*ttail(`e(N)',abs(_b[1.`variable']/_se[`variable']))
				if _rc == 0 {
					replace estimate`count' = string(round(_b[1.`variable'],.001),"%3.2f") if varname == "fgls`specification'_`variable'" & `pvalue' > .1
					replace estimate`count' = string(round(_b[1.`variable'],.001),"%3.2f")+"$^{*}$" if varname == "fgls`specification'_`variable'" & `pvalue' > .05 & `pvalue' <= .1
					replace estimate`count' = string(round(_b[1.`variable'],.001),"%3.2f")+"$^{**}$" if varname == "fgls`specification'_`variable'" & `pvalue' > .01 & `pvalue' <= .05
					replace estimate`count' = string(round(_b[1.`variable'],.001),"%3.2f")+"$^{***}$" if varname == "fgls`specification'_`variable'" & `pvalue' <= .01
					replace estimate`count' = "("+string(round(_se[1.`variable'],.001),"%3.2f")+")" if varname == "fgls`specification'_`variable'2"
					}
				}
				
			* Report regression details
			replace estimate`count' = "`obs' [`countries']" if Channel == "\# Observations [\# countries]"
			replace estimate`count' =string(round(`rsq',.001),"%3.2f") if Channel == "Adjusted R$ ^{2}$"
			replace estimate`count' = "yes" if Channel == "Region dummies" | Channel == "Year dummies" | Channel == "Years-of-independence dummies"
			
			* Save results of this model
			keep n Channel estimate`count'
			keep if estimate`count' != ""
		
			merge 1:1 n using `er', force
			keep if _merge == 3 | _merge == 2
			drop _merge
			save `er', replace
			restore
			
			* Drop unnecessary variables
			drop c_* y_* i_* 
			}
		
		* Bootstrap regression result
		
			* Tempfile to collect bootstrap estimates
			preserve
			clear all
			tempfile bs
			save `bs', emptyok
			restore
			

		noi di ""
		noi di ""
		noi di "Bootstrap regression approach"
		foreach specification of numlist 1/4 {
			
			* Keep track of progress
			local count = `count' + 1
			
			noi di ""
			noi di ""
			noi di "Specification `specification', bootstrap iteration (/${secondstepreps}):", _continue
			
			* Get background data
			if `specification' == 1 {				
				reg PTDIDD open market_potential dem popshare i.landlocked i.violent_secession bdeaths i.transition i.crisis i.doil i.year i.independence_years i.regioncode, cluster(cntrycode)
				}
			if `specification' == 2 {				
				reg PTDIDD open market_potential dem popshare initial_gdpcap i.landlocked i.violent_secession bdeaths i.transition i.crisis i.doil i.year i.independence_years i.regioncode, cluster(cntrycode)
				}
			if `specification' == 3 {	
				reg PTDIDD open market_potential dem popshare initial_gdpcap i.referendum_dummy i.landlocked i.violent_secession bdeaths i.transition i.crisis i.doil i.year i.independence_years i.regioncode, cluster(cntrycode)
				}
			if `specification' == 4 {						
				reg PTDIDD open market_potential dem popshare initial_gdpcap i.referendum_dummy i.landlocked i.violent_secession bdeaths i.transition i.crisis i.doil i.EU_dummy i.NATO_dummy i.AU_dummy i.ASEAN_dummy i.year i.independence_years i.regioncode, cluster(cntrycode)
				}
			local obs = `e(N)'
			local countries = `e(N_clust)'
			local rsq = `e(r2_a)'
			
			foreach iteration of numlist 1/$secondstepreps {
			noi di `iteration', _continue
			preserve
								
				* Draw independence dividend estimate
				replace PTDIDD = rnormal(PTDIDD,PTDIDD_se)
				
				* Keep relevant variables
				keep cntrycode PTDIDD open market_potential dem popshare initial_gdpcap referendum_dummy crisis transition landlocked violent_secession bdeaths  doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy year independence_years regioncode
											
				* Draw bootstrap sample of NICs
				sum cntrycode if independence_years == 0
				bsample `r(N)', cluster(cntrycode)
				
				* Standardize continuous variables
				ds cntrycode year independence_years regioncode  landlocked violent_secession crisis referendum_dummy doil EU_dummy NATO_dummy AU_dummy ASEAN_dummy transition, not
				foreach covariate in `r(varlist)' {
							egen `covariate'_std = std(`covariate')
							replace `covariate' = `covariate'_std
							drop `covariate'_std
							}
							
				* Define which dummies to omit
				char independence_years[omit] 0
				char year[omit] 1980
				char regioncode[omit] 1
	
				* Perform regressions of interest
				
					if `specification' == 1 {				
						xi: reg PTDIDD open market_potential dem popshare i.landlocked i.violent_secession  i.crisis i.transition bdeaths i.doil i.year i.independence_years i.regioncode
						}
					if `specification' == 2 {				
						xi: reg PTDIDD open market_potential dem popshare initial_gdpcap i.landlocked i.violent_secession  i.crisis i.transition bdeaths i.doil i.year i.independence_years i.regioncode
						}
					if `specification' == 3 {	
						xi: reg PTDIDD open market_potential dem popshare initial_gdpcap i.referendum_dummy i.landlocked i.violent_secession  i.crisis i.transition bdeaths i.doil i.year i.independence_years i.regioncode
						}
					if `specification' == 4 {						
						xi: reg PTDIDD open market_potential dem popshare initial_gdpcap i.referendum_dummy i.landlocked i.violent_secession  i.crisis i.transition bdeaths i.doil i.EU_dummy i.NATO_dummy i.AU_dummy i.ASEAN_dummy i.year i.independence_years i.regioncode
						}

				* Save parameter estimates
										
					* Channels
					ds cntrycode year independence_years regioncode, not
					foreach variable in `r(varlist)' {
						cap gen bs`specification'_`variable' = _b[`variable']
						cap gen bs`specification'_`variable' = _b[1.`variable']
						local id = substr("`variable'",1,9)
						cap gen bs`specification'_`variable' = _b[_I`id'_1]
						}
						
					gen iteration = `iteration'
					keep bs`specification'_* iteration
					keep in 1
					append using `bs', force
					save `bs', replace
					restore
				}

			* Compute point estimates & SE's of parameters of interest
			preserve
			use `bs', clear

			* Generate order
			gen n = _n
			gen str Channel = ""
			gen str varname = ""
			gen str estimate`count' = ""
				
			replace varname = "bs`specification'_popshare" if n == 1
			replace varname = "bs`specification'_popshare2" if n == 2
			replace varname = "bs`specification'_open" if n == 3
			replace varname = "bs`specification'_open2" if n == 4
			replace varname = "bs`specification'_market_potential" if n == 5 
			replace varname = "bs`specification'_market_potential2" if n == 6
			replace varname = "bs`specification'_landlocked" if n == 7
			replace varname = "bs`specification'_landlocked2" if n == 8
			replace varname = "bs`specification'_dem" if n == 9
			replace varname = "bs`specification'_dem2" if n == 10
			replace varname = "bs`specification'_violent_secession" if n == 11
			replace varname = "bs`specification'_violent_secession2" if n == 12
			replace varname = "bs`specification'_bdeaths" if n == 13
			replace varname = "bs`specification'_bdeaths2" if n == 14
			replace varname = "bs`specification'_crisis" if n == 15
			replace varname = "bs`specification'_crisis2" if n == 16
			replace varname = "bs`specification'_transition" if n == 17
			replace varname = "bs`specification'_transition2" if n == 18
			replace varname = "bs`specification'_doil" if n == 19
			replace varname = "bs`specification'_doil2" if n == 20
			replace varname = "bs`specification'_initial_gdpcap" if n == 21
			replace varname = "bs`specification'_initial_gdpcap2" if n == 22
			replace varname = "bs`specification'_referendum_dummy" if n == 23
			replace varname = "bs`specification'_referendum_dummy2" if n == 24
			replace varname = "bs`specification'_EU_dummy" if n == 25
			replace varname = "bs`specification'_EU_dummy2" if n == 26
			replace varname = "bs`specification'_NATO_dummy" if n == 27
			replace varname = "bs`specification'_NATO_dummy2" if n == 28
			replace varname = "bs`specification'_AU_dummy" if n == 29
			replace varname = "bs`specification'_AU_dummy2" if n == 30
			replace varname = "bs`specification'_ASEAN_dummy" if n == 31
			replace varname = "bs`specification'_ASEAN_dummy2" if n == 32
				
			replace Channel = "Population share" if n == 1
			replace Channel = "Trade openness" if n == 3
			replace Channel = "Market potential" if n == 5 
			replace Channel = "Landlocked" if n == 7
			replace Channel = "Democracy" if n == 9
			replace Channel = "Violent secession" if n == 11
			replace Channel = "Battle-related deaths" if n == 13
			replace Channel = "Financial crisis" if n == 15
			replace Channel = "Transition country" if n == 17
			replace Channel = "Oil producing country" if n == 19
			replace Channel = "Initial per capita GDP" if n == 21
			replace Channel = "Independence-by-referendum" if n == 23
			replace Channel = "EU membership" if n == 25
			replace Channel = "NATO membership" if n == 27
			replace Channel = "African Union membership" if n == 29
			replace Channel = "ASEAN membership" if n == 31
			replace Channel = "\# Observations [\# countries]" if n == 33
			replace Channel = "Adjusted R$ ^{2}$" if n == 34
			replace Channel = "Region dummies" if n == 35
			replace Channel = "Year dummies" if n == 36
			replace Channel = "Years-of-independence dummies" if n == 37
			replace Channel = "Bootstrap iterations" if n == 38
			
			ds iteration n, not
			foreach estimate in `r(varlist)' {
				sum `estimate'
				if `r(N)' > 0 {
					local pvalue = 2*ttail(`r(N)',abs(`r(mean)'/`r(sd)'))
					replace estimate`count' = string(round(`r(mean)',.001),"%3.2f") if varname == "`estimate'" & `pvalue' > .1
					replace estimate`count' = string(round(`r(mean)',.001),"%3.2f")+"$^{*}$" if varname == "`estimate'" & `pvalue' > .05 & `pvalue' <= .1
					replace estimate`count' = string(round(`r(mean)',.001),"%3.2f")+"$^{**}$" if varname == "`estimate'" & `pvalue' > .01 & `pvalue' <= .05
					replace estimate`count' = string(round(`r(mean)',.001),"%3.2f")+"$^{***}$" if varname == "`estimate'" & `pvalue' <= .01
					replace estimate`count' = "("+string(round(`r(sd)',.001),"%3.2f")+")" if varname == "`estimate'2"
					}
				}
							
			* Report regression details
			replace estimate`count' = "`obs' [`countries']" if Channel == "\# Observations [\# countries]"
			replace estimate`count' =string(round(`rsq',.001),"%3.2f") if Channel == "Adjusted R$ ^{2}$"
			replace estimate`count' = "yes" if Channel == "Region dummies" | Channel == "Year dummies" | Channel == "Years-of-independence dummies"
			replace estimate`count' = "$secondstepreps" if Channel == "Bootstrap iterations"
			
			* Save results of this model
			keep n Channel estimate`count'
			*keep if estimate`count' != ""
		
			merge 1:1 n using `er', force
			keep if _merge == 3 | _merge == 2
			drop _merge
			save `er', replace
			restore			
			}
					
		noi di ""
		noi di ""

		* Get all results & export them
			
			* Channels
			
				* Baseline FGLS results
				preserve
				use `er', clear
				drop if Channel == "Bootstrap iterations"
				cd "./5. TeX results"
				sort n
				noi list Channel estimate1 estimate2 estimate3 estimate4
				listtab Channel estimate1 estimate2 estimate3 estimate4 ///
				using table6.tex,  replace ///
				rstyle(tabular) ///
				headlines("\begin{tabular}{lcccc}\toprule\\ \emph{Channel}&\emph{(1)}&\emph{(2)}&\emph{(3)}&\emph{(4)}\\ \midrule") ///
				footlines("\bottomrule \end{tabular}")
				cd ..
				restore
				
				* Robustness bootstrap results
				preserve
				use `er', clear
				
				cd "./5. TeX results"
				sort n
				noi list Channel estimate5 estimate6 estimate7 estimate8
				listtab Channel estimate5 estimate6 estimate7 estimate8 ///
				using tableA6.tex,  replace ///
				rstyle(tabular) ///
				headlines("\begin{tabular}{lcccc}\toprule\\ \emph{Channel}&\emph{(1)}&\emph{(2)}&\emph{(3)}&\emph{(4)}\\ \midrule") ///
				footlines("\bottomrule \end{tabular}")
				cd ..
				restore
								
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
